/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.assets.characterviewer;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.google.inject.Guice;
import com.google.inject.Injector;
import java.util.Random;
import technology.rocketjump.undermount.assets.GameMaterialDictionary;
import technology.rocketjump.undermount.assets.characterviewer.CharacterViewUI;
import technology.rocketjump.undermount.assets.entities.item.model.ItemPlacement;
import technology.rocketjump.undermount.assets.entities.model.ColoringLayer;
import technology.rocketjump.undermount.assets.entities.model.EntityAssetOrientation;
import technology.rocketjump.undermount.entities.EntityAssetUpdater;
import technology.rocketjump.undermount.entities.components.ProfessionsComponent;
import technology.rocketjump.undermount.entities.factories.AccessoryColorFactory;
import technology.rocketjump.undermount.entities.factories.HairColorFactory;
import technology.rocketjump.undermount.entities.factories.HumanoidEntityFactory;
import technology.rocketjump.undermount.entities.factories.ItemEntityFactory;
import technology.rocketjump.undermount.entities.factories.SkinColorFactory;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.physical.humanoid.EquippedItemComponent;
import technology.rocketjump.undermount.entities.model.physical.humanoid.HumanoidEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemTypeDictionary;
import technology.rocketjump.undermount.guice.UndermountGuiceModule;
import technology.rocketjump.undermount.jobs.ProfessionDictionary;
import technology.rocketjump.undermount.rendering.DebugWindow;
import technology.rocketjump.undermount.rendering.RenderMode;
import technology.rocketjump.undermount.rendering.camera.PrimaryCameraWrapper;
import technology.rocketjump.undermount.rendering.entities.EntityRenderer;

public class CharacterViewApplication
extends ApplicationAdapter {
    private SpriteBatch batch;
    private ShapeRenderer shapeRenderer;
    private EntityRenderer entityRenderer;
    private HumanoidEntityFactory humanoidEntityFactory;
    private PrimaryCameraWrapper cameraManager;
    private CharacterViewUI ui;
    private Entity currentEntity;
    private HumanoidEntityAttributes attributes;
    private Color skinColor;
    private Color hairColor;
    private Color accessoryColor;
    private DebugWindow debugWindow;
    private Vector2 rotation = new Vector2(0.0f, 1.0f);

    @Override
    public void create() {
        Injector injector = Guice.createInjector(new UndermountGuiceModule());
        this.entityRenderer = injector.getInstance(EntityRenderer.class);
        this.humanoidEntityFactory = injector.getInstance(HumanoidEntityFactory.class);
        this.cameraManager = injector.getInstance(PrimaryCameraWrapper.class);
        this.debugWindow = injector.getInstance(DebugWindow.class);
        this.debugWindow.offsetPosition.x = 250.0f;
        this.batch = new SpriteBatch();
        this.shapeRenderer = new ShapeRenderer();
        Random random = new Random();
        this.skinColor = new SkinColorFactory().randomSkinColor(random);
        this.hairColor = new HairColorFactory().randomHairColor(random);
        this.accessoryColor = new AccessoryColorFactory().randomAccessoryColor(random);
        this.attributes = new HumanoidEntityAttributes(random.nextLong(), this.hairColor, this.skinColor, this.accessoryColor);
        Vector2 facing = new Vector2(0.0f, 0.0f);
        Vector2 position = new Vector2(this.cameraManager.getCamera().viewportWidth * 0.75f, this.cameraManager.getCamera().viewportHeight * 0.8f);
        this.currentEntity = this.humanoidEntityFactory.create(this.attributes, position, facing, null, null);
        ProfessionsComponent professionsComponent = this.currentEntity.getComponent(ProfessionsComponent.class);
        professionsComponent.add(injector.getInstance(ProfessionDictionary.class).getByName("MINER"), 0.8f);
        injector.getInstance(EntityAssetUpdater.class).updateEntityAssets(this.currentEntity);
        Entity heldItem = CharacterViewApplication.createItemEntity("Tool-Pickaxe", injector);
        EquippedItemComponent equippedItemComponent = new EquippedItemComponent();
        this.ui = injector.getInstance(CharacterViewUI.class);
        this.ui.init(this.currentEntity);
        Gdx.input.setInputProcessor(this.ui.getStage());
    }

    public static Entity createItemEntity(String itemTypeName, Injector injector) {
        ItemEntityFactory entityFactory = injector.getInstance(ItemEntityFactory.class);
        ItemTypeDictionary itemTypeDictionary = injector.getInstance(ItemTypeDictionary.class);
        GameMaterialDictionary gameMaterialDictionary = injector.getInstance(GameMaterialDictionary.class);
        ItemEntityAttributes attributes = new ItemEntityAttributes(0L);
        attributes.setQuantity(1);
        attributes.setItemType(itemTypeDictionary.getByName(itemTypeName));
        attributes.setMaterial(gameMaterialDictionary.getByName("Dolostone"));
        attributes.setMaterial(gameMaterialDictionary.getByName("Hematite"));
        attributes.setMaterial(gameMaterialDictionary.getByName("Ruby"));
        attributes.setMaterial(gameMaterialDictionary.getByName("Beech wood"));
        attributes.setMaterial(gameMaterialDictionary.getByName("Iron"));
        attributes.setColor(ColoringLayer.BRANCHES_COLOR, Color.BROWN);
        attributes.setColor(ColoringLayer.METAL_COLOR, new Color(0.7f, 0.7f, 0.8f, 1.0f));
        attributes.setItemPlacement(ItemPlacement.ON_GROUND);
        return entityFactory.create(attributes, new GridPoint2(), null);
    }

    @Override
    public void render() {
        this.renderBackground();
        this.batch.begin();
        this.batch.setProjectionMatrix(this.cameraManager.getCamera().combined);
        Vector2 originalPosition = this.currentEntity.getLocationComponent().getWorldPosition().cpy();
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.DOWN.toVector2(), 0.0f, 0.0f, RenderMode.DIFFUSE);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.DOWN_LEFT.toVector2(), -1.0f, 0.0f, RenderMode.DIFFUSE);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.DOWN_RIGHT.toVector2(), 1.0f, 0.0f, RenderMode.DIFFUSE);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.UP.toVector2(), 0.0f, 1.0f, RenderMode.DIFFUSE);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.UP_LEFT.toVector2(), -1.0f, 1.0f, RenderMode.DIFFUSE);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.UP_RIGHT.toVector2(), 1.0f, 1.0f, RenderMode.DIFFUSE);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.DOWN.toVector2(), 0.0f, -2.0f, RenderMode.NORMALS);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.DOWN_LEFT.toVector2(), -1.0f, -2.0f, RenderMode.NORMALS);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.DOWN_RIGHT.toVector2(), 1.0f, -2.0f, RenderMode.NORMALS);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.UP.toVector2(), 0.0f, -1.0f, RenderMode.NORMALS);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.UP_LEFT.toVector2(), -1.0f, -1.0f, RenderMode.NORMALS);
        this.renderEntityWithOrientation(originalPosition, EntityAssetOrientation.UP_RIGHT.toVector2(), 1.0f, -1.0f, RenderMode.NORMALS);
        this.batch.end();
        this.ui.render();
        this.debugWindow.render();
    }

    private void renderEntityWithOrientation(Vector2 originalPosition, Vector2 orientation, float offsetX, float offsetY, RenderMode renderMode) {
        this.currentEntity.getLocationComponent().setWorldPosition(originalPosition.cpy().add(orientation), true);
        this.currentEntity.getLocationComponent().setWorldPosition(originalPosition.cpy().add(offsetX, offsetY), false);
        this.entityRenderer.render(this.currentEntity, (Batch)this.batch, renderMode, null, null);
        this.currentEntity.getLocationComponent().setWorldPosition(originalPosition, false);
    }

    private void renderBackground() {
        Gdx.gl.glClearColor(0.6f, 0.6f, 0.6f, 1.0f);
        Gdx.gl.glClear(16384);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        this.shapeRenderer.setColor(0.7f, 0.7f, 0.7f, 1.0f);
        this.shapeRenderer.setProjectionMatrix(this.cameraManager.getCamera().combined);
        for (float x = 0.0f; x <= this.cameraManager.getCamera().viewportWidth + 1.0f; x += 0.5f) {
            for (float y = 0.0f; y <= this.cameraManager.getCamera().viewportHeight + 1.0f; y += 0.5f) {
                boolean yEven;
                boolean xEven = (float)Math.round(x) - x < 0.001f;
                boolean bl = yEven = (float)Math.round(y) - y < 0.001f;
                if ((!xEven || yEven) && (xEven || !yEven)) continue;
                this.shapeRenderer.rect(x, y, 0.5f, 0.5f);
            }
        }
        this.shapeRenderer.end();
    }

    @Override
    public void resize(int width, int height) {
        this.ui.onResize(width, height);
        this.cameraManager.onResize(width, height);
        this.cameraManager.getCamera().zoom = 0.5f;
        this.cameraManager.getCamera().update();
        this.debugWindow.onResize(width, height);
        Vector3 newPosition = new Vector3(width, height, 0.0f);
        newPosition.x *= 0.65f;
        newPosition.y *= 0.4f;
        this.cameraManager.getCamera().unproject(newPosition);
        newPosition.x = Math.round(newPosition.x);
        newPosition.y = Math.round(newPosition.y);
        this.currentEntity.getLocationComponent().setWorldPosition(new Vector2(newPosition.x, newPosition.y), false);
    }

    @Override
    public void dispose() {
        this.ui.dispose();
        this.batch.dispose();
    }
}

